
//Chris' WinGlide enhancements
//Copr. 1998, 1999 Chris Dohnal (cwdohnal@ucdavis.edu)

#include <windows.h>

#define FX_GLIDE_NO_FUNC_PROTO
#include <glide.h>
#include <glideutl.h>

#include "pointers.h"


//#define WG_ENTRY __declspec(dllexport)
#define WG_ENTRY __declspec(dllexport) __declspec(naked)
#define WG_CALL __stdcall


#define DOCALLI(func, params)	{ \
	__asm jmp _##func \
}

#define DOCALLF(func, params)	{ \
	__asm jmp _##func \
}

#define DOCALL(func, params)	{ \
	__asm jmp _##func \
}


VOID ErrorCallingFunction(LPCSTR);



WG_ENTRY void WG_CALL
grDrawPoint( const void *pt )
	DOCALL(grDrawPoint, ( const void *pt ));

WG_ENTRY void WG_CALL
grDrawLine( const void *v1, const void *v2 )
	DOCALL(grDrawLine, ( const void *v1, const void *v2 ));

WG_ENTRY void WG_CALL
grDrawTriangle( const void *a, const void *b, const void *c )
	DOCALL(grDrawTriangle, ( const void *a, const void *b, const void *c ));

WG_ENTRY void WG_CALL
grVertexLayout(FxU32 param, FxI32 offset, FxU32 mode)
	DOCALL(grVertexLayout, (FxU32 param, FxI32 offset, FxU32 mode));

WG_ENTRY void WG_CALL 
grDrawVertexArray(FxU32 mode, FxU32 Count, void *pointers)
	DOCALL(grDrawVertexArray, (FxU32 mode, FxU32 Count, void *pointers));

WG_ENTRY void WG_CALL 
grDrawVertexArrayContiguous(FxU32 mode, FxU32 Count, void *pointers, FxU32 stride)
	DOCALL(grDrawVertexArrayContiguous, (FxU32 mode, FxU32 Count, void *pointers, FxU32 stride));

WG_ENTRY void WG_CALL
grAADrawTriangle(
                 const void *a, const void *b, const void *c,
                 FxBool ab_antialias, FxBool bc_antialias, FxBool ca_antialias
                 )
	DOCALL(grAADrawTriangle, (
                 const void *a, const void *b, const void *c,
                 FxBool ab_antialias, FxBool bc_antialias, FxBool ca_antialias
                 ));

WG_ENTRY void WG_CALL
grBufferClear( GrColor_t color, GrAlpha_t alpha, FxU32 depth )
	DOCALL(grBufferClear, ( GrColor_t color, GrAlpha_t alpha, FxU32 depth ));

//WG_ENTRY void WG_CALL
//grBufferSwap( FxU32 swap_interval )
//	DOCALL(grBufferSwap, ( FxU32 swap_interval ));

WG_ENTRY void WG_CALL
grRenderBuffer( GrBuffer_t buffer )
	DOCALL(grRenderBuffer, ( GrBuffer_t buffer ));

typedef void (*GrErrorCallbackFnc_t)( const char *string, FxBool fatal );

WG_ENTRY void WG_CALL 
grErrorSetCallback( GrErrorCallbackFnc_t fnc )
	DOCALL(grErrorSetCallback, ( GrErrorCallbackFnc_t fnc ));

WG_ENTRY void WG_CALL 
grFinish(void)
	DOCALL(grFinish, (void));

WG_ENTRY void WG_CALL 
grFlush(void)
	DOCALL(grFlush, (void));

//WG_ENTRY GrContext_t WG_CALL 
//grSstWinOpen(
//          FxU32                hWnd,
//          GrScreenResolution_t screen_resolution,
//          GrScreenRefresh_t    refresh_rate,
//          GrColorFormat_t      color_format,
//          GrOriginLocation_t   origin_location,
//          int                  nColBuffers,
//          int                  nAuxBuffers)
//	DOCALL(grSstWinOpen, (
//          FxU32                hWnd,
//          GrScreenResolution_t screen_resolution,
//          GrScreenRefresh_t    refresh_rate,
//          GrColorFormat_t      color_format,
//          GrOriginLocation_t   origin_location,
//          int                  nColBuffers,
//          int                  nAuxBuffers));

//WG_ENTRY FxBool WG_CALL
//grSstWinClose( GrContext_t context )
//	DOCALLI(grSstWinClose, ( GrContext_t context ));

WG_ENTRY FxBool WG_CALL
grSelectContext( GrContext_t context )
	DOCALLI(grSelectContext, ( GrContext_t context ));

WG_ENTRY void WG_CALL
grSstOrigin(GrOriginLocation_t  origin)
	DOCALL(grSstOrigin, (GrOriginLocation_t  origin));

WG_ENTRY void WG_CALL 
grSstSelect( int which_sst )
	DOCALL(grSstSelect, ( int which_sst ));

WG_ENTRY void WG_CALL
grAlphaBlendFunction(
                     GrAlphaBlendFnc_t rgb_sf,   GrAlphaBlendFnc_t rgb_df,
                     GrAlphaBlendFnc_t alpha_sf, GrAlphaBlendFnc_t alpha_df
                     )
	DOCALL(grAlphaBlendFunction, (
                     GrAlphaBlendFnc_t rgb_sf,   GrAlphaBlendFnc_t rgb_df,
                     GrAlphaBlendFnc_t alpha_sf, GrAlphaBlendFnc_t alpha_df
                     ));

WG_ENTRY void WG_CALL
grAlphaCombine(
               GrCombineFunction_t function, GrCombineFactor_t factor,
               GrCombineLocal_t local, GrCombineOther_t other,
               FxBool invert
               )
	DOCALL(grAlphaCombine, (
               GrCombineFunction_t function, GrCombineFactor_t factor,
               GrCombineLocal_t local, GrCombineOther_t other,
               FxBool invert
               ));

WG_ENTRY void WG_CALL
grAlphaControlsITRGBLighting( FxBool enable )
	DOCALL(grAlphaControlsITRGBLighting, ( FxBool enable ));

WG_ENTRY void WG_CALL
grAlphaTestFunction( GrCmpFnc_t function )
	DOCALL(grAlphaTestFunction, ( GrCmpFnc_t function ));

WG_ENTRY void WG_CALL
grAlphaTestReferenceValue( GrAlpha_t value )
	DOCALL(grAlphaTestReferenceValue, ( GrAlpha_t value ));

WG_ENTRY void WG_CALL 
grChromakeyMode( GrChromakeyMode_t mode )
	DOCALL(grChromakeyMode, ( GrChromakeyMode_t mode ));

WG_ENTRY void WG_CALL 
grChromakeyValue( GrColor_t value )
	DOCALL(grChromakeyValue, ( GrColor_t value ));

WG_ENTRY void WG_CALL 
grClipWindow( FxU32 minx, FxU32 miny, FxU32 maxx, FxU32 maxy )
	DOCALL(grClipWindow, ( FxU32 minx, FxU32 miny, FxU32 maxx, FxU32 maxy ));

WG_ENTRY void WG_CALL 
grColorCombine(
               GrCombineFunction_t function, GrCombineFactor_t factor,
               GrCombineLocal_t local, GrCombineOther_t other,
               FxBool invert )
	DOCALL(grColorCombine, (
               GrCombineFunction_t function, GrCombineFactor_t factor,
               GrCombineLocal_t local, GrCombineOther_t other,
               FxBool invert ));

WG_ENTRY void WG_CALL
grColorMask( FxBool rgb, FxBool a )
	DOCALL(grColorMask, ( FxBool rgb, FxBool a ));

WG_ENTRY void WG_CALL 
grCullMode( GrCullMode_t mode )
	DOCALL(grCullMode, ( GrCullMode_t mode ));

WG_ENTRY void WG_CALL 
grConstantColorValue( GrColor_t value )
	DOCALL(grConstantColorValue, ( GrColor_t value ));

WG_ENTRY void WG_CALL 
grDepthBiasLevel( FxI32 level )
	DOCALL(grDepthBiasLevel, ( FxI32 level ));

WG_ENTRY void WG_CALL 
grDepthBufferFunction( GrCmpFnc_t function )
	DOCALL(grDepthBufferFunction, ( GrCmpFnc_t function ));

WG_ENTRY void WG_CALL 
grDepthBufferMode( GrDepthBufferMode_t mode )
	DOCALL(grDepthBufferMode, ( GrDepthBufferMode_t mode ));

WG_ENTRY void WG_CALL 
grDepthMask( FxBool mask )
	DOCALL(grDepthMask, ( FxBool mask ));

WG_ENTRY void WG_CALL 
grDisableAllEffects( void )
	DOCALL(grDisableAllEffects, ( void ));

WG_ENTRY void WG_CALL 
grDitherMode( GrDitherMode_t mode )
	DOCALL(grDitherMode, ( GrDitherMode_t mode ));

WG_ENTRY void WG_CALL 
grFogColorValue( GrColor_t fogcolor )
	DOCALL(grFogColorValue, ( GrColor_t fogcolor ));

WG_ENTRY void WG_CALL 
grFogMode( GrFogMode_t mode )
	DOCALL(grFogMode, ( GrFogMode_t mode ));

WG_ENTRY void WG_CALL 
grFogTable( const GrFog_t ft[] )
	DOCALL(grFogTable, ( const GrFog_t ft[] ));

WG_ENTRY void WG_CALL 
grLoadGammaTable( FxU32 nentries, FxU32 *red, FxU32 *green, FxU32 *blue)
	DOCALL(grLoadGammaTable, ( FxU32 nentries, FxU32 *red, FxU32 *green, FxU32 *blue));

WG_ENTRY void WG_CALL
grSplash(float x, float y, float width, float height, FxU32 frame)
	DOCALL(grSplash, (float x, float y, float width, float height, FxU32 frame));

WG_ENTRY FxU32 WG_CALL 
grGet( FxU32 pname, FxU32 plength, FxI32 *params )
	DOCALLI(grGet, ( FxU32 pname, FxU32 plength, FxI32 *params ));

WG_ENTRY const char * WG_CALL 
grGetString( FxU32 pname )
	DOCALLI(grGetString, ( FxU32 pname ));

WG_ENTRY FxI32 WG_CALL 
grQueryResolutions( const GrResolution *resTemplate, GrResolution *output )
	DOCALLI(grQueryResolutions, ( const GrResolution *resTemplate, GrResolution *output ));

WG_ENTRY FxBool WG_CALL 
grReset( FxU32 what )
	DOCALLI(grReset, ( FxU32 what ));

WG_ENTRY GrProc WG_CALL
grGetProcAddress( char *procName )
	DOCALLI(grGetProcAddress, ( char *procName ));

//WG_ENTRY void WG_CALL 
//grEnable( GrEnableMode_t mode )
//	DOCALL(grEnable, ( GrEnableMode_t mode ));

//WG_ENTRY void WG_CALL 
//grDisable( GrEnableMode_t mode )
//	DOCALL(grDisable, ( GrEnableMode_t mode ));

WG_ENTRY void WG_CALL 
grCoordinateSpace( GrCoordinateSpaceMode_t mode )
	DOCALL(grCoordinateSpace, ( GrCoordinateSpaceMode_t mode ));

WG_ENTRY void WG_CALL 
grDepthRange( FxFloat n, FxFloat f )
	DOCALL(grDepthRange, ( FxFloat n, FxFloat f ));

WG_ENTRY void WG_CALL 
grViewport( FxI32 x, FxI32 y, FxI32 width, FxI32 height )
	DOCALL(grViewport, ( FxI32 x, FxI32 y, FxI32 width, FxI32 height ));

WG_ENTRY FxU32 WG_CALL 
grTexCalcMemRequired(
                     GrLOD_t lodmin, GrLOD_t lodmax,
                     GrAspectRatio_t aspect, GrTextureFormat_t fmt)
	DOCALLI(grTexCalcMemRequired, (
                     GrLOD_t lodmin, GrLOD_t lodmax,
                     GrAspectRatio_t aspect, GrTextureFormat_t fmt));

WG_ENTRY FxU32 WG_CALL 
grTexTextureMemRequired( FxU32     evenOdd,
                                 GrTexInfo *info   )
	DOCALLI(grTexTextureMemRequired, ( FxU32     evenOdd,
                                 GrTexInfo *info   ));

WG_ENTRY FxU32 WG_CALL 
grTexMinAddress( GrChipID_t tmu )
	DOCALLI(grTexMinAddress, ( GrChipID_t tmu ));

WG_ENTRY FxU32 WG_CALL 
grTexMaxAddress( GrChipID_t tmu )
	DOCALLI(grTexMaxAddress, ( GrChipID_t tmu ));

WG_ENTRY void WG_CALL 
grTexNCCTable( GrNCCTable_t table )
	DOCALL(grTexNCCTable, ( GrNCCTable_t table ));

WG_ENTRY void WG_CALL 
grTexSource( GrChipID_t tmu,
             FxU32      startAddress,
             FxU32      evenOdd,
             GrTexInfo  *info )
	DOCALL(grTexSource, ( GrChipID_t tmu,
             FxU32      startAddress,
             FxU32      evenOdd,
             GrTexInfo  *info ));

WG_ENTRY void WG_CALL 
grTexClampMode(
               GrChipID_t tmu,
               GrTextureClampMode_t s_clampmode,
               GrTextureClampMode_t t_clampmode
               )
	DOCALL(grTexClampMode, (
               GrChipID_t tmu,
               GrTextureClampMode_t s_clampmode,
               GrTextureClampMode_t t_clampmode
               ));

WG_ENTRY void WG_CALL 
grTexCombine(
             GrChipID_t tmu,
             GrCombineFunction_t rgb_function,
             GrCombineFactor_t rgb_factor, 
             GrCombineFunction_t alpha_function,
             GrCombineFactor_t alpha_factor,
             FxBool rgb_invert,
             FxBool alpha_invert
             )
	DOCALL(grTexCombine, (
             GrChipID_t tmu,
             GrCombineFunction_t rgb_function,
             GrCombineFactor_t rgb_factor, 
             GrCombineFunction_t alpha_function,
             GrCombineFactor_t alpha_factor,
             FxBool rgb_invert,
             FxBool alpha_invert
             ));

WG_ENTRY void WG_CALL 
grTexDetailControl(
                   GrChipID_t tmu,
                   int lod_bias,
                   FxU8 detail_scale,
                   float detail_max
                   )
	DOCALL(grTexDetailControl, (
                   GrChipID_t tmu,
                   int lod_bias,
                   FxU8 detail_scale,
                   float detail_max
                   ));

WG_ENTRY void WG_CALL 
grTexFilterMode(
                GrChipID_t tmu,
                GrTextureFilterMode_t minfilter_mode,
                GrTextureFilterMode_t magfilter_mode
                )
	DOCALL(grTexFilterMode, (
                GrChipID_t tmu,
                GrTextureFilterMode_t minfilter_mode,
                GrTextureFilterMode_t magfilter_mode
                ));


WG_ENTRY void WG_CALL 
grTexLodBiasValue(GrChipID_t tmu, float bias )
	DOCALL(grTexLodBiasValue, (GrChipID_t tmu, float bias ));

WG_ENTRY void WG_CALL 
grTexDownloadMipMap( GrChipID_t tmu,
                     FxU32      startAddress,
                     FxU32      evenOdd,
                     GrTexInfo  *info )
	DOCALL(grTexDownloadMipMap, ( GrChipID_t tmu,
                     FxU32      startAddress,
                     FxU32      evenOdd,
                     GrTexInfo  *info ));

WG_ENTRY void WG_CALL 
grTexDownloadMipMapLevel( GrChipID_t        tmu,
                          FxU32             startAddress,
                          GrLOD_t           thisLod,
                          GrLOD_t           largeLod,
                          GrAspectRatio_t   aspectRatio,
                          GrTextureFormat_t format,
                          FxU32             evenOdd,
                          void              *data )
	DOCALL(grTexDownloadMipMapLevel, ( GrChipID_t        tmu,
                          FxU32             startAddress,
                          GrLOD_t           thisLod,
                          GrLOD_t           largeLod,
                          GrAspectRatio_t   aspectRatio,
                          GrTextureFormat_t format,
                          FxU32             evenOdd,
                          void              *data ));

WG_ENTRY FxBool WG_CALL 
grTexDownloadMipMapLevelPartial( GrChipID_t        tmu,
                                 FxU32             startAddress,
                                 GrLOD_t           thisLod,
                                 GrLOD_t           largeLod,
                                 GrAspectRatio_t   aspectRatio,
                                 GrTextureFormat_t format,
                                 FxU32             evenOdd,
                                 void              *data,
                                 int               start,
                                 int               end )
	DOCALLI(grTexDownloadMipMapLevelPartial, ( GrChipID_t        tmu,
                                 FxU32             startAddress,
                                 GrLOD_t           thisLod,
                                 GrLOD_t           largeLod,
                                 GrAspectRatio_t   aspectRatio,
                                 GrTextureFormat_t format,
                                 FxU32             evenOdd,
                                 void              *data,
                                 int               start,
                                 int               end ));

WG_ENTRY void WG_CALL
grTexDownloadTable( GrTexTable_t type, 
                    void         *data )
	DOCALL(grTexDownloadTable, ( GrTexTable_t type, 
                    void         *data ));

WG_ENTRY void WG_CALL
grTexDownloadTablePartial( GrTexTable_t type, 
                           void         *data,
                           int          start,
                           int          end )
	DOCALL(grTexDownloadTablePartial, ( GrTexTable_t type, 
                           void         *data,
                           int          start,
                           int          end ));

WG_ENTRY void WG_CALL 
grTexMipMapMode( GrChipID_t     tmu, 
                 GrMipMapMode_t mode,
                 FxBool         lodBlend )
	DOCALL(grTexMipMapMode, ( GrChipID_t     tmu, 
                 GrMipMapMode_t mode,
                 FxBool         lodBlend ));

WG_ENTRY void WG_CALL 
grTexMultibase( GrChipID_t tmu,
                FxBool     enable )
	DOCALL(grTexMultibase, ( GrChipID_t tmu,
                FxBool     enable ));

WG_ENTRY void WG_CALL
grTexMultibaseAddress( GrChipID_t       tmu,
                       GrTexBaseRange_t range,
                       FxU32            startAddress,
                       FxU32            evenOdd,
                       GrTexInfo        *info )
	DOCALL(grTexMultibaseAddress, ( GrChipID_t       tmu,
                       GrTexBaseRange_t range,
                       FxU32            startAddress,
                       FxU32            evenOdd,
                       GrTexInfo        *info ));

WG_ENTRY FxBool WG_CALL
grLfbLock( GrLock_t type, GrBuffer_t buffer, GrLfbWriteMode_t writeMode,
           GrOriginLocation_t origin, FxBool pixelPipeline, 
           GrLfbInfo_t *info )
	DOCALLI(grLfbLock, ( GrLock_t type, GrBuffer_t buffer, GrLfbWriteMode_t writeMode,
           GrOriginLocation_t origin, FxBool pixelPipeline, 
           GrLfbInfo_t *info ));

WG_ENTRY FxBool WG_CALL
grLfbUnlock( GrLock_t type, GrBuffer_t buffer )
	DOCALLI(grLfbUnlock, ( GrLock_t type, GrBuffer_t buffer ));

WG_ENTRY void WG_CALL 
grLfbConstantAlpha( GrAlpha_t alpha )
	DOCALL(grLfbConstantAlpha, ( GrAlpha_t alpha ));

WG_ENTRY void WG_CALL 
grLfbConstantDepth( FxU32 depth )
	DOCALL(grLfbConstantDepth, ( FxU32 depth ));

WG_ENTRY void WG_CALL 
grLfbWriteColorSwizzle(FxBool swizzleBytes, FxBool swapWords)
	DOCALL(grLfbWriteColorSwizzle, (FxBool swizzleBytes, FxBool swapWords));

WG_ENTRY void WG_CALL
grLfbWriteColorFormat(GrColorFormat_t colorFormat)
	DOCALL(grLfbWriteColorFormat, (GrColorFormat_t colorFormat));

WG_ENTRY FxBool WG_CALL
grLfbWriteRegion( GrBuffer_t dst_buffer, 
                  FxU32 dst_x, FxU32 dst_y, 
                  GrLfbSrcFmt_t src_format, 
                  FxU32 src_width, FxU32 src_height, 
                  FxBool pixelPipeline,
                  FxI32 src_stride, void *src_data )
	DOCALLI(grLfbWriteRegion, ( GrBuffer_t dst_buffer, 
                  FxU32 dst_x, FxU32 dst_y, 
                  GrLfbSrcFmt_t src_format, 
                  FxU32 src_width, FxU32 src_height, 
                  FxBool pixelPipeline,
                  FxI32 src_stride, void *src_data ));

WG_ENTRY FxBool WG_CALL
grLfbReadRegion( GrBuffer_t src_buffer,
                 FxU32 src_x, FxU32 src_y,
                 FxU32 src_width, FxU32 src_height,
                 FxU32 dst_stride, void *dst_data )
	DOCALLI(grLfbReadRegion, ( GrBuffer_t src_buffer,
                 FxU32 src_x, FxU32 src_y,
                 FxU32 src_width, FxU32 src_height,
                 FxU32 dst_stride, void *dst_data ));

WG_ENTRY void WG_CALL
grGlideInit( void )
	DOCALL(grGlideInit, ( void ));

WG_ENTRY void WG_CALL
grGlideShutdown( void )
	DOCALL(grGlideShutdown, ( void ));

WG_ENTRY void WG_CALL
grGlideGetState( void *state )
	DOCALL(grGlideGetState, ( void *state ));

WG_ENTRY void WG_CALL
grGlideSetState( const void *state )
	DOCALL(grGlideSetState, ( const void *state ));

WG_ENTRY void WG_CALL
grGlideGetVertexLayout( void *layout )
	DOCALL(grGlideGetVertexLayout, ( void *layout ));

WG_ENTRY void WG_CALL
grGlideSetVertexLayout( const void *layout )
	DOCALL(grGlideSetVertexLayout, ( const void *layout ));


WG_ENTRY void WG_CALL 
guGammaCorrectionRGB( FxFloat red, FxFloat green, FxFloat blue )
	DOCALL(guGammaCorrectionRGB, ( FxFloat red, FxFloat green, FxFloat blue ));

WG_ENTRY float WG_CALL
guFogTableIndexToW( int i )
	DOCALLF(guFogTableIndexToW, ( int i ));

WG_ENTRY void WG_CALL
guFogGenerateExp( GrFog_t *fogtable, float density )
	DOCALL(guFogGenerateExp, ( GrFog_t *fogtable, float density ));

WG_ENTRY void WG_CALL
guFogGenerateExp2( GrFog_t *fogtable, float density )
	DOCALL(guFogGenerateExp2, ( GrFog_t *fogtable, float density ));

WG_ENTRY void WG_CALL
guFogGenerateLinear(GrFog_t *fogtable,
                    float nearZ, float farZ )
	DOCALL(guFogGenerateLinear, (GrFog_t *fogtable,
                    float nearZ, float farZ ));

WG_ENTRY FxBool WG_CALL
gu3dfGetInfo( const char *filename, Gu3dfInfo *info )
	DOCALLI(gu3dfGetInfo, ( const char *filename, Gu3dfInfo *info ));

WG_ENTRY FxBool WG_CALL
gu3dfLoad( const char *filename, Gu3dfInfo *data )
	DOCALLI(gu3dfLoad, ( const char *filename, Gu3dfInfo *data ));


VOID ErrorCallingFunction(LPCSTR szName) {
	#define MAX_NAME_LEN	64
	static char szErrorCalling[] = "Error calling: _";
	char szMessage[MAX_NAME_LEN + sizeof(szErrorCalling)];

	lstrcpy(szMessage, szErrorCalling);
	lstrcat(szMessage, szName);
	MessageBox(NULL, szMessage, "Error in WinGlide", MB_OK | MB_ICONSTOP);
	return;
}
